//
//  SecurityProceduresViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 14.02.23.
//

import UIKit

class SecurityProceduresViewController : UIViewController {
    
    
    @IBOutlet var topHeaderLabel: UILabel!
    
    @IBOutlet weak var deviceLabel: UILabel!
    
    @IBOutlet var registeredDevicesLabel: UILabel!
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        topHeaderLabel.font = Fonts.mediumFontWithSize(size: 18)
        
        registeredDevicesLabel.font = Fonts.mediumFontWithSize(size: 16)
        
        deviceLabel.numberOfLines = 0
        deviceLabel.lineBreakMode = .byTruncatingTail
        let details = NSMutableAttributedString.init(string: "   Max iPhone\n   Geräte ID: FL5SG-95BNH-X71B3")
        
        details.setAttributes([NSAttributedString.Key.font: Fonts.lightFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                   range: NSMakeRange(0, 13))
        
        deviceLabel.attributedText = details
        
        deviceLabel.font = Fonts.lightFontWithSize(size: 15)
        
        deviceLabel.layer.cornerRadius = 10
        deviceLabel.layer.masksToBounds = true
        deviceLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner, .layerMinXMaxYCorner, .layerMaxXMaxYCorner]

        
    }
}
